/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks;

import com.flanks255.simplybackpacks.commands.SBCommands;
import com.flanks255.simplybackpacks.configuration.CommonConfiguration;
import com.flanks255.simplybackpacks.configuration.ConfigCache;
import com.flanks255.simplybackpacks.crafting.CopyBackpackDataRecipe;
import com.flanks255.simplybackpacks.crafting.TargetNBTIngredient;
import com.flanks255.simplybackpacks.data.Generator;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.FilterGui;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.gui.SBGui;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.network.OpenMessage;
import com.flanks255.simplybackpacks.network.SBNetwork;
import com.flanks255.simplybackpacks.network.ToggleMessage;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import com.flanks255.simplybackpacks.util.RecipeUnlocker;
import com.flanks255.simplybackpacks.util.TagLookup;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="simplybackpacks")
public class SimplyBackpacks {
    public static final String MODID = "simplybackpacks";
    public static final Logger LOGGER = LogManager.getLogger((String)"simplybackpacks");
    public static SimpleChannel NETWORK;
    public static final TagKey<Item> HOLDS_ITEMS;
    public static final TagKey<Item> CURIOS_BACK;
    public static final TagKey<Enchantment> SOULBOUND;
    public static final TagLookup<Enchantment> SOULBOUND_LOOKUP;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINERS;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    public static final RegistryObject<RecipeSerializer<?>> COPYRECIPE;
    public static final RegistryObject<MenuType<SBContainer>> SBCONTAINER;
    public static final RegistryObject<MenuType<FilterContainer>> FILTERCONTAINER;
    public static final RegistryObject<Item> COMMONBACKPACK;
    public static final RegistryObject<Item> UNCOMMONBACKPACK;
    public static final RegistryObject<Item> RAREBACKPACK;
    public static final RegistryObject<Item> EPICBACKPACK;
    public static final RegistryObject<Item> ULTIMATEBACKPACK;
    private final NonNullList<KeyMapping> keyBinds = NonNullList.m_122779_();

    public SimplyBackpacks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        CONTAINERS.register(bus);
        RECIPES.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfiguration.COMMON_CONFIG);
        bus.addListener(this::onConfigReload);
        MinecraftForge.EVENT_BUS.addListener(this::onCommandsRegister);
        bus.addListener(this::setup);
        bus.addListener(this::clientStuff);
        bus.addListener(Generator::gatherData);
        bus.addListener(this::onEnqueueIMC);
        MinecraftForge.EVENT_BUS.addListener(this::pickupEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        BackpackUtils.curiosLoaded = ModList.get().isLoaded("curios");
        RecipeUnlocker.register(MODID, MinecraftForge.EVENT_BUS, 2);
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (BackpackUtils.curiosLoaded) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CraftingHelper.register((ResourceLocation)TargetNBTIngredient.Serializer.NAME, (IIngredientSerializer)TargetNBTIngredient.SERIALIZER));
        NETWORK = SBNetwork.register();
    }

    private void onCommandsRegister(RegisterCommandsEvent event) {
        SBCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void pickupEvent(EntityItemPickupEvent event) {
        ItemStack stack;
        if (event.getPlayer().f_36096_ instanceof SBContainer || event.getPlayer().m_6047_() || event.getItem().m_32055_().m_41720_() instanceof BackpackItem) {
            return;
        }
        if (BackpackUtils.curiosLoaded && !(stack = CuriosApi.getCuriosHelper().findEquippedCurio(BackpackItem::isBackpack, event.getEntityLiving()).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && BackpackItem.pickupEvent(event, stack)) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        Inventory playerInv = event.getPlayer().m_150109_();
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack2 = playerInv.m_8020_(i);
            if (!(stack2.m_41720_() instanceof BackpackItem) || !BackpackItem.pickupEvent(event, stack2)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        if (((KeyMapping)this.keyBinds.get(0)).m_90859_()) {
            NETWORK.sendToServer((Object)new ToggleMessage());
        }
        if (((KeyMapping)this.keyBinds.get(1)).m_90859_()) {
            NETWORK.sendToServer((Object)new OpenMessage());
        }
    }

    private void clientStuff(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)SBCONTAINER.get()), SBGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)FILTERCONTAINER.get()), FilterGui::new);
        this.keyBinds.add(0, (Object)new KeyMapping("key.simplybackpacks.backpackpickup.desc", -1, "key.simplybackpacks.category"));
        this.keyBinds.add(1, (Object)new KeyMapping("key.simplybackpacks.backpackopen.desc", -1, "key.simplybackpacks.category"));
        ClientRegistry.registerKeyBinding((KeyMapping)((KeyMapping)this.keyBinds.get(0)));
        ClientRegistry.registerKeyBinding((KeyMapping)((KeyMapping)this.keyBinds.get(1)));
    }

    private void onConfigReload(ModConfigEvent event) {
        ConfigCache.RefreshCache();
    }

    static {
        HOLDS_ITEMS = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("forge", "holds_items"));
        CURIOS_BACK = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("curios", "back"));
        SOULBOUND = TagKey.m_203882_((ResourceKey)Registry.f_122902_, (ResourceLocation)new ResourceLocation("forge", "soulbound"));
        SOULBOUND_LOOKUP = new TagLookup<Enchantment>(ForgeRegistries.ENCHANTMENTS, SOULBOUND);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)MODID);
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MODID);
        COPYRECIPE = RECIPES.register("backpack_upgrade", CopyBackpackDataRecipe.Serializer::new);
        SBCONTAINER = CONTAINERS.register("sb_container", () -> IForgeMenuType.create(SBContainer::fromNetwork));
        FILTERCONTAINER = CONTAINERS.register("filter_container", () -> IForgeMenuType.create(FilterContainer::fromNetwork));
        COMMONBACKPACK = ITEMS.register("commonbackpack", () -> new BackpackItem("commonbackpack", Backpack.COMMON));
        UNCOMMONBACKPACK = ITEMS.register("uncommonbackpack", () -> new BackpackItem("uncommonbackpack", Backpack.UNCOMMON));
        RAREBACKPACK = ITEMS.register("rarebackpack", () -> new BackpackItem("rarebackpack", Backpack.RARE));
        EPICBACKPACK = ITEMS.register("epicbackpack", () -> new BackpackItem("epicbackpack", Backpack.EPIC));
        ULTIMATEBACKPACK = ITEMS.register("ultimatebackpack", () -> new BackpackItem("ultimatebackpack", Backpack.ULTIMATE));
    }
}

